/**
 *  特权模块
 */

define(['wpsApi','utils','domLazyload', 'dataServices'], function(WPSAPI, UTIL, domLazy, DataServices) {

    //缓存面板tab插件
    var vm = {};

    avalon.component('ms:privilege', {

        componentId: '',

        isCompany:false,//是否是企业用户
        isLogin:false,//是否已登录
        userinfo:{},//用户信息
        userid:'',//用户id
        //basePrivilegeData:[],//基础特权列表 包含企业、会员、普通用户数据
        needLoadPic:false,//是否需要加载特权详情图片
        $skipArray: [],
        _init: function() {
            setTimeout(function(){
                // var userinfo=LOGIN.getUserInfo();
                var userinfo = DATAMODEL.userInfo;
                if(userinfo && userinfo.userid) {
                    vm.loginSuccess();
                } else {
                    vm.logoutSuccess();
                }
            },1000);
            //如果应用页面有应用下载开始或下载成功
            $.subscribe('app_downloadApp', function(appName) {
                vm.getAppList();
            });
        },
        //数据收集
        sendCollect:function(p4,p5,p6){
            // COLLECT.sendCollect(p4,p5,p6);
        },
        //登录成功需要处理逻辑
        loginSuccess:function(){
            vm.isLogin=true;
            vm.userinfo = DATAMODEL.userInfo;
            if(vm.userinfo.companyid&&vm.userinfo.companyid>0){
                vm.isCompany=true;
            }else{
                vm.isCompany=false;
            }
            vm.getPrivilegeDataList();//加载特权数据
        },
        //退出成功需要处理逻辑
        logoutSuccess:function(){
            vm.privilegeList=[];
            vm.isLogin=false;
            vm.userinfo={};
            vm.userid="";
        },
        //更新应用列表数据
        updatePrivilegeData:function(appName,name,value){
            if(!appName){
                return;
            }
            $.each(vm.privilegeList,function(i,v){
                if(v["link"]==appName){
                    v[name]=value;
                }
            })
        },
        openlink:function(url){
            if(!url){
                return;
            }
            // 内跳
            //docer.wps.cn/partner.php/yearcard/v1/?from=_mywps_newhompage_pic&position=wps_homepage
            if (vm.selectedIndex != '-1' && vm.privilegeList[vm.selectedIndex]['type'] == 'innerlink' && url.indexOf('http') == -1) {
                // 字符串操作
                var urlObj = UTIL.getRequest(url),
                    tempUrl = '';
                avalon.each(urlObj, function (key, val) {
                    tempUrl += key + '=' + val + '&';
                });
                /*setTimeout(function() {
                    window.avalon.vmodels.CenterVM.openMonthCard(url.split('?')[0] + '?' + tempUrl);
                }, 200);*/
                url = tempUrl;
            }
            open(url);
        },
        setValuePri:function(name,value){
            //延迟加载dom
            domLazy.add('priviDesc', vm.componentId);
            vm[name]=value;
        },
        privilegeList:[],//特权列表
        selectedIndex:-1,//当前显示的特权
        userType:'',//用户类型 enterprise vip normal
        //获取特权基础数据并加已处理，除应用是否点亮外;
        getPrivilegeDataList: function() {
            if (vm.isCompany) { //企业用户
                vm.userType = 'enterprise';
            } else { //个人用户
                if (vm.userinfo.vip.memberid > 10) {
                    vm.userType = 'vip';
                } else {
                    vm.userType = 'normal';
                }
            }
            var data = '',
                key = "privilege_" + vm.userType + "_" + DATAMODEL.timestamp;
            try {
                data = localStorage.getItem(key) || window[key];
            } catch (e) {
                data = window[key];
            }
            // data = JSON.stringify(vm.tempPrivilegeDataList.$model);
            
            if (!data) {
                vm.getBasePrivilegeData();
                return;
            }
            var _privilegeList = [];
            try {
                _privilegeList = JSON.parse(data); //临时存放特权数据变量
            } catch (e) { _privilegeList = []; }
            if (!vm.isCompany && vm.isLogin) {
                if (vm.userid && vm.userid == vm.userinfo.userid) {
                    return;
                } else {
                    vm.userid = vm.userinfo.userid;
                }
            }
            if (!_privilegeList.length) { //没有数据就返回
                return;
            }
            //按版本排序&设置默认点亮特权
            $.each(_privilegeList, function(index, v) {
                /*处理稻壳月卡是否点亮
                if(v.index==21&&vm.userinfo&&vm.userinfo.monthcard){
                    try{
                        if('undefined'!=typeof(vm.userinfo.monthcard.is_expired)&&vm.userinfo.monthcard.is_expired==0){
                            v["light"]=1;
                        }
                    }catch(e){}
                }*/
                v["state"] = 1; // 1未安装 2安装中 3已安装
                v["downloadError"] = "";
                v["progress"] = 0;
            })
            vm.privilegeList = _privilegeList;
            vm.getAppList(); //获取应用列表数据，修改是否点亮应用图标
        },

        // 特权图标点击
        clickPrivilegeIcon: function (url) {
            if (vm.selectedIndex != '-1' && vm.privilegeList[vm.selectedIndex]['top_btn_name'] == '稻壳') {
                vm.sendCollect(19, 7, 'top_icon_click');
            }
            vm.openlink(url);
        },

        //特权播放gif动画
        privilege_video_player:'',
        // 图片点击
        // type     
        /*'link'        => '外部跳转',
        'innerlink'     => '内部跳转',
        'video_player'  => '播放器打开',
        */        
        clickPrivilegePic: function (url,type) {
            if (vm.selectedIndex != '-1' && vm.privilegeList[vm.selectedIndex]['top_btn_name'] == '稻壳') {
                vm.sendCollect(19, 7, 'pic_click')
            }
            if(!type||type=='link'){
                vm.openlink(url);
            }else if(type=='video_player'){
                vm.privilege_video_player=url;
            }
        },
        //顶部开通按钮
        topButton:function(index){
            var p=vm.privilegeList[index].$model;
            if(p.top_btn_name=='查看'){
                vm.sendCollect(19,3);
            }
            if (p.top_btn_name == '稻壳') {
                vm.sendCollect(19, 7, 'top_btn_click');
            }
            switch(p.type){
                case 'view'://阅览
                    break;
                case 'innerlink':
                case 'link'://跳转
                    vm.openlink(p.link);
                    break;
                case 'cloud_font'://云字体
                    vm.jsAsynCall({"method":"openOnlineFontDialog"},false).done(function(resp){});
                    break;
                case 'online_skin'://在线皮肤
                    vm.jsAsynCall({"method":"openSwitchFaceDialog"},false).done(function(resp){});
                    break;
                case 'apply'://应用
                    if(p.state==1){
                        vm.downloadApp(1,p.link);
                        vm.sendCollect(19,2);
                    }else if(p.state==3){
                        if(p.link=="wpsspeaker"){
                            $("#applywpsspeaker").html("请打开文档后，在特色功能中使用").show();
                            setTimeout(function(){
                                $("#applywpsspeaker").fadeOut(500);
                            },2500);
                        }else{
                            //启动app
                            vm.openAPP(p.link);
                        }
                    }
                    break;
            }
        },
        //底部开通按钮
        bottomButton:function(index){
            var p=vm.privilegeList[index].$model;
            var url=p.bottom_btn_link;
            if (p.top_btn_name == '稻壳') {
                vm.sendCollect(19, 7, 'word_click');
            }
            if(p.bottom_btn_type&&p.bottom_btn_type=='member'){
                window.avalon.vmodels.globleVM.openPayment(url);
            }else{
                // 打开年卡支付
                //wps.docer.wps.cn/partner.php/monthcard/v1?servicetype=yearcard&yearcardonly=true&csource=_my_wps_newhomepage&position=wps_homepage;
                if (p.bottom_btn_type=='innerlink' && url.indexOf('http') == -1) {

                    // 增加组件类型到csource中
                    var urlObj = UTIL.getRequest(url);
                    url = '';
                    avalon.each(urlObj, function (key, val) {
                        url += key + '=' + val + '&';
                    });


                    // 购买稻壳会员
                    window.avalon.vmodels.globleVM.openPayment(url);

                // 外跳
                } else {
                     vm.openlink(url);
                }
            }
            if(vm.isCompany){//企业用户
                vm.sendCollect(19,6)
            }else{//个人用户
                if(vm.userinfo.vip.memberid>10){
                    vm.sendCollect(19,5)
                }else{
                    vm.sendCollect(19,4,p.name)
                }
            }
        },        
        lastSourceUrl:'',//最后一次请求数据接口
        tempPrivilegeDataList: '',
        //获取特权列表
        getBasePrivilegeData:function() {
            var url="https://api.vas.wpscdn.cn"+"/privilege/v1/wpshome/"+vm.userType;
            if(vm.lastSourceUrl==url){
                return;
            }
            vm.lastSourceUrl=url;
            $.each(localStorage,function(key,value){
                if(key.indexOf('privilege_'+vm.userType+'_')!=-1&&key!='privilege_'+vm.userType+'_'+DATAMODEL.timestamp){
                    localStorage.removeItem(key,'')
                }
            });

            DataServices.get('privilege').privilegeData({data: {}, url: url}).done(function(resp) {    
                resp = resp.data;
                if(resp.result=='ok'){
                    var key="privilege_"+vm.userType+"_"+DATAMODEL.timestamp;
                    try{
                        localStorage.setItem(key,JSON.stringify(resp.data))    
                    }catch(e){
                        window[key]=JSON.stringify(resp.data);
                    }
                    vm.tempPrivilegeDataList = resp.data;
                    vm.getPrivilegeDataList();
                }
                vm.lastSourceUrl='';
            })
        },
        //=====================================================================================
        //=====================================================================================
        timer:[],//下载进度
        appList:[],//全部应用列表 这里不会有数据
        myAppList:[],//已下载应用列表
        loopDownload:false,//是否监控下载进度中
        //轮询应用下载进度
        //start?新的启动轮询开始
        loopDownloadStatus:function(start){
            //已在监控下载状态中无需重复启动
            if(start&&vm.loopDownload){return;}
            //是否需要继续监控下载逻辑
            var needLoop=false;
            $.each(vm.timer,function(index,v){
                if(v.status==1){
                    if(!needLoop){
                        needLoop=true;
                    }
                    vm.queryAppDownloadProgress(v.type,v.name);
                }
            })
            if(needLoop){
                vm.loopDownload=true;
                setTimeout(function(){vm.loopDownloadStatus()},1400);
            }else{
                vm.loopDownload=false;
            }
        },
        //查询下载进度
        /*用途: 查询下载进度
        input_json:
        {
            "method"    :   "queryAppDownloadProgress",
            "appName"   :   "", // 从applist里面获得的应用名称
            "callback"  :   "jscallback",
        }
        result_json:
        {
            "result"    :   0/1, // 0=查询成功，1=查询失败
            "msg"       :   "ok/error", // result的进一步描述
            "progress"  :   1-100, // -1表示下载失败
        }*/
        queryAppDownloadProgress:function(type,appName){            
            var data={"method":"queryAppDownloadProgress", "params": {appName: appName}};
            vm.jsAsynCall(data,true).done(function(resp){
                if(resp.result=="0"){
                    if(resp.progress>-1){
                        vm.updatePrivilegeData(appName,"progress",resp.progress);
                    }
                    if(resp.progress==100){//下载完了需要更新app状态
                        vm.updatePrivilegeData(appName,"state",3);
                        $.each(vm.timer,function(index,v){
                            if(v.name==appName&&v.type==type){//设置该应用已经下载完成状态
                                v.status=2;
                                return;
                            }
                        })
                        if(type==1){//true 需要去更新已下载列表
                            setTimeout(function(){vm.getAddedAppList();},1000);
                        }
                    }else if(resp.progress==-1){//下载失败
                        vm.updatePrivilegeData(appName,"downloadError","安装失败,请重试");
                        vm.updatePrivilegeData(appName,"state",1);//未下载
                        $.each(vm.timer,function(index,v){
                            if(v.name==appName){//设置该应用已经下载完成状态
                                v.status=0;//未下载状态
                            }
                        })
                    }
                }
            })
        },     
        /**
         * [updateAppStatus description]
         * @param  {[type]} type    [1 applist 2 myapplist]
         * @param  {[type]} appName [description]
         * @param  {[type]} key     [description]
         * @param  {[type]} value   [description]
         * @return {[type]}         [description]
         */
        //更新应用数据进度
        updateAppData:function(type,appName,key,value){
            $.each(type==1?vm.appList:vm.myAppList,function(index,v){
                if(v.name==appName){
                    v[key]=value;
                }
            })
        },
        /**
         * [downloadApp description]
         * @param  {[type]} type [1 applist 2 myapplist]
         * @param  {[type]} appName [description]
         * @param  {[type]} from [来源]
         * @return {[type]}      [description]
         */
        /*用途: 下载应用
        input_json:
        {
            "method"    :   "downloadApp",
            "appName"   :   "", // 从applist里面获得的应用名称
            "callback"  :   "jscallback",
        }
        result_json:
        {
            "result"    :   0/1, // 0=下载成功，1=下载失败，2=下载中
            "msg"       :   "ok/error", // result的进一步描述
        }*/
        downloadApp:function(type,appName,download_from){
            var data={"method":"downloadApp", "params": {appName: appName}};
            vm.jsAsynCall(data,true).done(function(resp){
                if(resp.result=="0"||resp.result=="2"){
                    vm.updatePrivilegeData(appName,"downloadError","");
                    vm.updatePrivilegeData(appName,"state",2);//下载中
                    var exist=false;
                    $.each(vm.timer,function(index,v){
                        if(v.name==appName&&v.type==type){
                            v.status=1;
                            exist=true;
                            return;
                        }
                    })
                    if(!exist){
                        vm.timer.push({name:appName,type:type,status:1});
                    }
                    //启动监控下载进度接口
                    vm.loopDownloadStatus(true);
                    if(!download_from){//如果下载来源为空表示是页面下载
                        $.publish("home_downloadApp",appName);
                    }
                }else if(resp.result=="1"){
                    vm.updatePrivilegeData(appName,"downloadError","安装失败,请重试");
                }
            });
        },
        //打开体验
        /*用途: 启动应用
        input_json:
        {
            "method"    :   "startApp",
            "appName"   :   "", // 从applist里面获得的应用名称
            "callback"  :   "jscallback",
        }
        result_json:
        {
            "result"    :   0/1/2, // 0=操作成功，1=操作失败，2=不适合在首页启动
            "msg"       :   "ok/some error happened", // result的进一步描述
        }*/
        openAPP:function(appName){
            if(appName=="wpsspeaker"){
                $("#applywpsspeaker").html("请打开文档后，在特色功能中使用").show()
                setTimeout(function(){
                    $("#applywpsspeaker").fadeOut(500);
                },2500)
                return;
            }
            var data={"method":"startApp","params": {appName : appName}};
            vm.updatePrivilegeData(appName,"state",4);
            setTimeout(function(){
                vm.updatePrivilegeData(appName,"state",3);
            },3000)
            vm.jsAsynCall(data,true).done(function(resp){
                if(resp.result=="1"){//操作失败
                    
                }else if(resp.result=="1"){//不适合在首页启动
                    
                }
            })
        },
        //获取已添加的应用列表数据
        /*
        用途: 获取已添加应用列表
        input_json:
        {
            "method"    :   "getAddedAppList",
            "callback"  :   "jscallback",
        }

        result_json:
        {
            "result"    :   0/1/2, // 0=ok， 1=获取失败，2=正在准备，稍后再调
            "msg"       :   "", // result的进一步描述
            "apps" : [
                {
                    "name"          :   "", // 应用名称，应用的唯一标识
                    "version"       :   "", // 版本
                    "img"           :   "", // 图片地址
                    "status"        :   0/1/2/3, // 0=当前最新，1=有更新版本，2=更新中，3=更新失败
                    "progress"      :   0~100, // 更新进度
                    "redpoint"      :   0/1
                }
                ...
            ],
        } */
        getAddedAppList:function(num){
            !num&&(num=1);            
            var data={"method":"getAddedAppList"};
            vm.jsAsynCall(data,true).done(function(resp){
                if(resp.result=="0"){
                    var temp=[];
                    $.each(resp.apps,function(index,v){
                        temp.push(v);
                        if(v.status==2){
                            vm.downloadApp(2,v.name,'getAddedAppList');
                            vm.updatePrivilegeData(v.name,"state",2);//下载中
                        }else if(v.status==0){//已下载                            
                            vm.updatePrivilegeData(v.name,"state",3);//设置已点亮
                        }
                    })
                    vm.myAppList=temp;
                }else{
                    setTimeout(function(){
                        if(num<4){
                            num+=1;
                            vm.getAddedAppList(num);
                        }
                    },2000);
                }
            })
        },
        //获取应用列表数据
        /*
        input_json:
        {
            "method"    :   "getAppList", 注：2018该接口名称改为getApps
            "callback"  :   "jscallback",
        }
        result_json:
        {
            "result"    :   0/1/2, // 0=ok， 1=获取失败，2=正在准备，稍后再调
            "msg"       :   "", // result的进一步描述
            "apps" : [
                {
                    "name"          :   "", // 应用名称，应用的唯一标识
                    "version"       :   "", // 版本
                    "displayName"   :   "", // 显示名称
                    "desc"          :   "", // 应用简短描述
                    "img"           :   "", // 图片地址
                    "detailDesc"    :   "", // 应用详细描述
                    "actionPath"    :   "", // 功能路径
                    "recommend"     :   0/1, // 1=属推荐应用
                    "host"          :   ["wps", "wpp", "et"], // 所属组件
                    "runMode"       :   0/1, // 0=独立运行，1=依赖组件
                    "status"        :   0/1/2/3/4, // 0=未加载，1=加载中，2=已加载，3=取消加载，4=加载失败
                    "progress"      :   0~100, // 加载进度
                }
                ...
            ],
        }*/
        getAppList:function(num){
            !num&&(num=1);            
            var data={"method":"getApps"};
            vm.jsonstr=num;
            vm.jsAsynCall(data,true).done(function(resp){
                if(resp.result=="0"){
                    var temp=[];
                    $.each(resp.apps,function(index,v){
                        temp.push(v);
                        if(v.status==1){//下载中
                            vm.downloadApp(1,v.name,'getAppList');
                            vm.updatePrivilegeData(v.name,"state",2);//下载中
                        }else if(v.status==2){//已下载
                            vm.updatePrivilegeData(v.name,"state",3);//已下载
                        }
                    })
                    vm.appList=temp;
                }else{
                    setTimeout(function(){
                        if(num<4){
                            num+=1;
                            vm.getAppList(num);
                        }
                    },2000);
                }
            })
        },
        //客户端 异步调用入口
        jsAsynCall : function(data, needReturn) {
            // 兼容新版，把是否需要返回值写进data
            if (needReturn === true) {
                data.callback = true;
            }
            return WPSAPI.jsAsynCall(data);
        },

        $ready: function(vmodel) {
            vm = vmodel;
            vm.componentId = vmodel.$id;
            vmodel.onInit(vmodel);
        },

        $init: function (vmodel) {
        },

        $template: $('#privilege_template').html()
    });
})
