define(['dataServices', 'utils'], function (DataServices, Utils) {

    var model = avalon.define({
        $id: 'LoginVM',

        userInfo: '',

        loginDisplay: false,

        isLogin: false,

        $skinArray: [],

        init: function () {
            model.updateUserInfo();
        },

        getUser: function () {
            return model.userInfo.$model;
        },

        // 控制发送请求次数
        requestCount: 0,
        updateUserInfo: () => {
            var deff = $.Deferred();
            if (window.WPSSID == '') {
                model.userInfo = '';
                model.isLogin = false;
                window.DATAMODEL = {};
                window.DATAMODEL.userInfo = '';
                window.DATAMODEL.isDocer = window.DATAMODEL.isWpsVip = window.DATAMODEL.isSuper = window.DATAMODEL.isCompany = false;
                setTimeout(() => {
                    $.publish('updateUserInfo', [{result: "error", data: "", msg: "no_login"}]);
                }, 50);
                deff.resolve({result: "error", data: "", msg: "no_login"});
                return deff;
            }
            DataServices.get('user').getUserInfo().done((resp) => {
                resp = resp.data;
                console.log(`用户信息数据：${JSON.stringify(resp)}`);
                window.DATAMODEL = {};
                if (resp.result === 'ok') {
                    resp.data.vip.expire_time = Utils.secondsToDate(resp.data.vip.expire_time * 1000);
                    var _userinfo = window.DATAMODEL.userInfo = resp.data;
                    model.userInfo = resp.data;
                    if (_userinfo) {
                        var isDocer = false,
                            isWpsVip = false,
                            isSuper = false,
                            isCompany = false;
                        $.each(_userinfo.vip.enabled, function (k, v) {
                            if (v.memberid === 12) {
                                isDocer = true;
                            } else if (v.memberid === 40) {
                                isSuper = true;
                            } else if (v.memberid === 20) {
                                isWpsVip = true;
                            } else if (v.memberid > 40) {
                                isCompany = true;
                            }
                        });
                        if (_userinfo.vip.memberid > 40) {
                            isCompany = true;
                        }
                        window.DATAMODEL.isDocer = isDocer;
                        window.DATAMODEL.isWpsVip = isWpsVip;
                        window.DATAMODEL.isSuper = isSuper;
                        window.DATAMODEL.isCompany = isCompany;
                    }
                    model.isLogin = !!model.userInfo.nickname;
                    $.publish('updateUserInfo', [resp]);
                } else {
                    model.userInfo = '';
                    model.isLogin = false;
                    window.DATAMODEL.userInfo = '';
                    window.DATAMODEL.isDocer = window.DATAMODEL.isWpsVip = window.DATAMODEL.isSuper = window.DATAMODEL.isCompany = false;
                    $.publish('updateUserInfo', [{result: "error", data: "", msg: "no_login"}]);
                }
                deff.resolve(resp);
            }).fail(function (resp) {
                $.publish('updateUserInfo', [{result: "error", data: "", msg: "no_login"}]);
            });
            return deff;
        }
    });

    // 临时处理方案 - 等待客户端写入cookies的wps_sid
    /* $.subscribe('userstate', function(a, json) {
        model.updateUserInfo();
    }); */

    return model;
})
