/*
 * 客户端接口模块
 * 
 * @Author: wang.jx 
 * @Date: 2017-07-20 08:37:29 
 * @Last Modified by: wucipo
 * @Last Modified time: 2017-09-25 10:17:35
 */

define(['base64', 'utils'], function(BASE64, UTILS) {
    'use strict';

    var WpsApi = function () {

        //客户端 异步调用入口
        var jsAsynCall = function (data) {
            var defer = $.Deferred();
            //需要 返回值
            if (data.callback === true) {
                var _callback = data.callback = 'panel_asyn_cb_' + (Math.floor(Math.random() * 1000));

                window[_callback] = function (response) {
                    var result = {};
                    try {
                        result = $.parseJSON(BASE64.decode(response));
                    } catch (_e) {
                        try {
                            result = eval('(' + BASE64.decode(response) + ')');
                        } catch (_ee) {
                            result = {
                                result: response,
                                exception: 'JSON PARSE ERROR'
                            };
                        }
                    }

                    //调用接口正确
                    if (result.callstatus === 'ok') {
                        defer.resolve(result);
                    } else {
                        if (result.callstatus === 'error' && result.errormsg === "NETWORK_ERROR") {
                            defer.reject({
                                msgcode: 400,
                                msg: 'timeout',
                                result: 'fail'
                            });
                        } else {
                            defer.reject(response);
                        }
                    }
                    delete window[_callback];
                };

                //兼容web模式触发回调以保持流程一致 弃用
                /* if (!WpsApi.check()) {
                    setTimeout(function () {
                        defer.resolve({ isweb: true });
                    });
                } */
            }

            try {
                if (window.cefQuery) {
                    var request_id = window.cefQuery({
                        request: 'fromJSAsynCallBase64("' + BASE64.encode(JSON.stringify(data)) + '")',
                        onSuccess: function (response) {

                        },
                        onFailure: function (error_code, error_message) {

                        }
                    });
                } else {
                    //qt内核调用模式
                    window.qwebkit.qwebkit_invoke(BASE64.encode(JSON.stringify(data)));
                }

            } catch (_e) {

            }
            return defer;
        };

        return {

            jsAsynCall: jsAsynCall,

            /**
             * 弹出Minisite窗口, 按指定的宽高(宽高指定需托盘模式才有效)
             */
            showMini: function (width, height, circle) {
                return jsAsynCall({
                    'method': 'ClickNotify',
                    'params': {
                        'type': 'adjustcontainer',
                        'content': width + ':' + height + ':minisite:' + circle,
                    },
                    'callback': true
                });
            },

            //AES编码 
            JsEnCodeString: function (value) {
                return jsAsynCall({
                    'method': 'AESEncrypt',
                    'params': {
                        'string': value,
                    },
                    'callback': true
                });
            },

            //AES解码 
            JsDeCodeString: function (value) {
                return jsAsynCall({
                    'method': 'AESDecrypt',
                    'params': {
                        'string': value,
                    },
                    'callback': true
                });
            },

            //使用默认浏览器打开需带登录信息超链接
            openQingUrl: function (url) {
                jsAsynCall({
                    'method': 'openUrlQing',
                    'params':{
                        'url': url
                    }
                });
            },

            //使用默认浏览器打开超链接
            openUrl: function (url) {
                jsAsynCall({
                    'method': 'openUrl',
                    'params':{
                        'url': url
                    }
                });
            },

            //弹出登录框
            login: function () {
                jsAsynCall({
                    'method': 'login'
                });
            },

            //退出登录
            logout: function () {
                jsAsynCall({
                    'method': 'common.account.logout'
                });
            },

            //检查登录状态,调用就会触发 loginCallback，但要先监听registerListener
            checkLogin: function () {
                jsAsynCall({
                    'method': 'checkLoginState',
                    'callback': true
                });
            },

            //注册事件
            registerListener: function (eName, cbName) {
                jsAsynCall({
                    'method': 'common.event.addEventListener',
                    'params':{
                        'eventName': eName,
                        'callbackName': cbName
                    }
                });
            },

            // 清楚事件
            removeEventListener: function () {
                jsAsynCall({
                    'method': 'common.event.removeEventListener',
                    'params':{
                        'eventName': 'onloginchanged'
                    }
                });
            },

            //JS GET请求
            jsGet: function (url, param, time, header) {
                return jsAsynCall({
                    "method": "common.network.httpRequest",
                    'params':{
                        "type": 'get',
                        "data": param,
                        "url": url, // 请求url
                        "timeout": time,
                        "header": header
                    },
                    "callback": true
                });
            },

            //JS POST请求 接口
            jsPost: function (url, param, time, header) {
                return jsAsynCall({
                    "method": "common.network.httpRequest",
                    'params':{
                        "type": 'post',
                        "data": param,
                        "url": url, // 请求url
                        "timeout": time,
                        "header": header
                    },
                    "callback": true
                });
            },

            //写客户端缓存
            writeSetting: function (key, value, enCode) {
                jsAsynCall({
                    'method': 'CallExApi',
                    'func': 'wini',
                    'param': 'default;minisite;' + key + ';' + (enCode ? BASE64.encode(value) : value)
                });
            },

            //读客户端缓存
            readSetting: function (key, deCode) {
                var seft = this,
                    deferred = $.Deferred();

                jsAsynCall({
                    'method': 'CallExApi',
                    'func': 'rini',
                    'param': 'default;minisite;' + key,
                    'callback': true
                }).then(function (resp) {
                    //如果输出前需Base64解码
                    deferred.resolve((!resp.isweb && deCode) ? BASE64.decode(resp.result) : resp.result);
                });

                return deferred;
            },

            // 获取客户端参数： {"appname":"fake appname","callstatus":"ok","channel":"fake channel","guid":"fake guid","hdid":"fake hdid","jsApiVersion":"fake channel","uuid":"fake uuid","version":"fake version"}
            getAppInfo: function () {
                return jsAsynCall({
                    "method": "getAppInfo",
                    "callback": true
                });
            },

            //返回用户环境其它浏览器的历史记录
            getViewHistory: function () {
                return jsAsynCall({
                    "method": "collectHistory",
                    'params': {
                        "duration": 700
                    },
                    "callback": true
                });
            },

            // 打开浏览器载入链接
            qingOpenVipUrl: function (url) {
                jsAsynCall({
                    'method': 'qingOpenVipUrl',
                    'params': {
                        'callbackurl': url
                    }
                });
            },

            // 客户端本地缓存
            localstorageAdd: function (key, value, stmp, flag) {
                jsAsynCall({
                    'method': 'localstorageAdd',
                    'params': {
                        key: key,
                        val: value,
                        stamp: stmp,
                        flag: flag
                    }
                });
            },
            // 获取主页的当前频道，获取规则是先用户制定频道，获取不到再返回预设频道（旧）
            getCurrentChannel: function () {
                jsAsynCall({
                    'method': 'getCurrentChannel',
                    "callback": true
                });
            },
            // 设置预设加载频道
            setPresetChannel: function (channelId) {
                jsAsynCall({
                    'method': 'removeRectFile',
                    'params': {
                        'preset_channel': channelId
                    },
                });
            },
            // 判断当前运行的容器
            runtime: function () {
                /**
                 * homepageapi兼容处理
                 */
                var docerApi;

                try {
                    if (window.homepageapiasync) {
                        docerApi = window.homepageapiasync;
                    } else {
                        docerApi = window.homepageapi;
                    }
                } catch (e) {

                }

                //判断当前运行的容器 
                var runContanainer = docerApi ? 'webkit' : (window.cefQuery ? 'cef' : 'browser');

                return runContanainer;
            },

            /**
             * 呼出支付窗
             */
            openPayment: function (paramsStr) {
                jsAsynCall({
                    'method': 'common.payment.open',
                    'params': {
                        'csource': paramsStr || ''
                    },
                });
            },

            /**
             * 关闭窗口
             * @param id webview窗口id
             */
            closeWindow: function (id) {
                var obj = {};
                if (id) {
                    obj = {
                        'method': 'close',
                        'params': {
                            'id': id
                        },
                    };
                } else {
                    obj = {
                        'method': 'close',
                    };
                }
                jsAsynCall(obj);
            },

            /**
             * 打开窗口
             * @param url 页面地址
             * @param showFlag 是否立即展示
             * 
             * @return id webview标识符 
             */
            openWindow: function (url, showFlag) {
                jsAsynCall({
                    'method': 'common.webview.open',
                    'params': {
                        'url': url,
                        'show': showFlag,
                    },
                    callback: true
                });
            },

            /**
             * 最大化
             * @param id webview窗口id
             */
            maximizeWindow: function (id) {
                var obj = {};
                if (id) {
                    obj = {
                        'method': 'maximize',
                        'params': {
                            'id': id
                        },
                    };
                } else {
                    obj = {
                        'method': 'maximize',
                    };
                }
                jsAsynCall(obj);
            },

            /**
             * 最小化
             * @param id webview窗口id
             */
            minimizeWindow: function (id) {
                var obj = {};
                if (id) {
                    obj = {
                        'method': 'minimize',
                        'params': {
                            'id': id
                        },
                    };
                } else {
                    obj = {
                        'method': 'minimize',
                    };
                }
                jsAsynCall(obj);
            },

            // 客户端会员统一支付
            memberUniformPay: function (pageSource) {
                jsAsynCall({
                    'method': 'upgradeVip',
                    'params': {
                        'pageSource': pageSource,
                    },
                    'callback': true
                });
            },

            /**
             * 返回主页
             */
            gotoMainPage: function () {
                jsAsynCall({
                    'method': 'gotoMainPage'
                });
            },

            /**
             * tab中打开页面
             * @param url 页面地址
             */
            newPage: function (url) {
                jsAsynCall({
                    'method': 'newPage',
                    'params': {
                        'url': url
                    },
                });
            },

            /**
             * 切换用户
             */
            switchUser: function (email) {
                jsAsynCall({
                    'method': 'switchUser',
                    'params': {
                        'email': email
                    },
                });
            },
            
            /**
             * 切换用户
             */
            queryUser: function () {
                return jsAsynCall({
                    "method": 'queryUser',
                    "callback": true
                });
            },

            /**
             * 模板-最近使用
             */
            gotoHistory: function () {
                jsAsynCall({
                    'method': 'gotoHistory'
                });
            },
            
            /**
             * 模板-已购买
             */
            gotoPurchases: function () {
                jsAsynCall({
                    'method': 'gotoPurchases'
                });
            },
            
            /**
             * 模板-已收藏
             */
            gotoFav: function () {
                jsAsynCall({
                    'method': 'gotoFav'
                });
            },
            
            /**
             * 模板-我的模板
             */
            gotoMyTemplate: function () {
                jsAsynCall({
                    'method': 'gotoMyTemplate'
                });
            },

            /**
             * 拖动区域
             */
            addDragArea: function (left, top, width, height) {
                jsAsynCall({
                    'method': 'addDragArea',
                    'params': {
                        'left': left,
                        'top': top,
                        'width': width,
                        'height': height
                    }
                });
            },

            clearDragArea: function () {
                jsAsynCall({
                    'method': 'clearDragArea'
                });
            },

            // 获取用户信息
            getUserInfo: function () {
                return jsAsynCall({
                    'method': 'common.account.getUserInfo',
                    "callback": true
                });
            },

            // 唤起网页授权模态框
            openWebAuthDialog: function (params) {
                return jsAsynCall({
                    'method': 'openWebAuthDialog',
                    'params': params,
                    "callback": true
                });
            },

            // 获取用户的文件漫游状态
            getAutoRoamingMode: function (params) {
                return jsAsynCall({
                    'method': 'getAutoRoamingMode',
                    'params': params,
                    "callback": true
                });
            },

            // 设置用户的文件漫游模式，手动还是自动
            changeRoamingMode: function (params) {
                return jsAsynCall({
                    'method': 'changeRoamingMode',
                    'params': params,
                    "callback": true
                });
            },

            // 设置网页授权结果
            setWebAuthResult: function (params) {
                return jsAsynCall({
                    'method': 'setWebAuthResult',
                    'params': params,
                    "callback": true
                });
            },
            /**
             * 监听窗口放大缩小
             */
            addWindowStatusListener: function (cbName) {
                return jsAsynCall({
                    'method': 'addWindowStatusListener',
                    'params': {
                        'callbackName': cbName
                    }
                });
            }
            
        };
    }();
    
    //登录状态监听回调
    window.loginCallback = function (codestr) {
        if (UTILS.checkIsClient()){
            var loginstr = BASE64.decode(codestr);
            //act=notifyLoginStatus&logined=true&userid=12462101&wpskey=e45803a5b26f5581e948053ba968f30fcb3672150000be2815
            var json = {};
    
            loginstr.split('&').forEach(function (i) {
                var j = i.split('=');
                json[j[0]] = j[1];
            });
            window.WPSSID = json.wpskey;
        } else {
            window.WPSSID = '';
            // WpsApi.gotoMainPage();
        }
        setTimeout(function () {
            var LOGIN = require('login');
            LOGIN.init();
        }, 200);
    };

    window._debugapicallback = function (jsonstr) {
        console.warn(jsonstr);
    };

    //便于调试接口输出返回值
    window.debugapi = function (methodname, param) {
        if (!window.cefQuery || !window.qtWebkitQuery) {
            console.error('APPLY ONLY MINISITE');
            return;
        }

        var callparam = {
            'method': methodname,
            'callback': '_debugapicallback'
        };

        if (param != null) $.extend(callparam, param);

        WpsApi.jsAsynCall(callparam);

    };
    
    if (UTILS.checkIsClient()) {
        // 移除监听登录状态
        // WpsApi.removeEventListener();
        //监听登陆状态变更
        WpsApi.registerListener('onloginchanged', 'loginCallback');
        //检查登录状态
        WpsApi.checkLogin();
    } else {
        window.loginCallback();
    }

    return WpsApi;
});