
require.config({
    paths: {
        'domReady': 'libs/require/domReady',
        'mmRouter': 'libs/avalon/mmRouter',
        'mmHistory': 'libs/avalon/mmHistory',
        'store': 'libs/store/store',
        'dataServices': 'resource/dataServices',
        'wpsApi': 'controllers/wpsApi',
        'login': 'controllers/login',
        'switchUser': 'controllers/switchUser',
        'domLazyload': 'controllers/domLazyload',
        'http': 'controllers/http',
        'utils': 'utils/utils',
        'secondsToDate': 'utils/secondsToDate',
        'base64': 'utils/base64',
        'getRequest': 'utils/getRequest',
        'config': 'utils/config',
        'getMousePos': 'utils/getMousePos',
        'queryUrlParams': 'utils/queryUrlParams',
        'home': 'modules/home/home',
        'money': 'modules/home/money',
        'template': 'modules/home/template',
        'cloud': 'modules/home/cloud',
        'member': 'modules/home/member',
        'privilegeComponent': 'components/privilege',
    },
    map: {
        '*': {
            'css': 'libs/require/css'
        }
    },
    shim: {
        'modules/home/home': {
            deps: [
                // 'css!../../../css/home.css'
            ]
        },
        'modules/info/info': {
            deps: [
                // 'css!../../../css/info.css'
            ]
        },
        'modules/security/security': {
            deps: [
                // 'css!../../../css/security.css'
            ]
        }
    },
    priority: ['text']
});
/**
 * 路由主入口
 */
require(['mmRouter', 'domReady!', 'login', 'wpsApi', 'utils', 'switchUser', 'home', 'dataServices', 'privilegeComponent'], function (mmRouter, domReady, Login, WpsApi, Utils, SwitchUser, HomeVM, DataServices) {

    /**
     * 路由跳转时的加载中
     */
    avalon.templateCache.loadingPage = '<div class="temloading" style="display:block;"><div class="ldimg"></div><p>加载中...</p></div>';

    avalon.templateCache.home = '';

    var model = avalon.define({

        $id: 'globleVM',

        content: 'loadingPage',

        userInfo: '',

        isLogin: Login.isLogin,

        isClient: window.isClient,

        isCompany: false,

        isDocer: false,

        isWpsVip: false,

        isSuper: false,

        $skipArray: ['loadModule'],

        // 面板tab组件
        panelmenuVM: null,

        // 特权组件
        privilegeVM: null,

        // 客户端类型
        appType: Utils.app,

        // 网络连接失败
        info500: false,

        href: function (url) {
            return model.isClient ? 'javascript:void(0);' : url;
        },

        target: function () {
            return model.isClient ? '_blank' : '_self';
        },

        reload: function () {
            window.location.reload();
        },

        /**
         * 操作窗体
         */
        maximizeWindow: function () {
            WpsApi.maximizeWindow();
        },
        minimizeWindow: function () {
            WpsApi.minimizeWindow();
        },
        closeWindow: function () {
            WpsApi.closeWindow();
        },

        /**
         * 返回主页
         */
        gotoMainPage: function () {
            WpsApi.gotoMainPage();
        },

        /**
         * tab中打开页面
         */
        newPage: function (url) {
            if (!model.isLogin) {
                WpsApi.login();
                return;
            }
            WpsApi.newPage(url);
        },

        /* 
         * 登录 兼容 两端 （客户端和web端）
         */
        gotoLogin: function (event, origin) {
            if (!window.event) {
                window.event = event;
            }
            if (!model.isLogin) {
                WpsApi.login();
                if (event) {
                    event.stopPropagation();
                    event.preventDefault();
                }
            } else {
                if (event) {
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        },

        /**
         * 设置通用属性
         * @param {String} modelID avalon模块ID
         * @param {String} key 模块对应属性
         * @param {String} value 属性对应值
         */
        setValue: function (event, modelID, key, value) {
            if (!window.event) {
                window.event = event;
            }
            event.stopPropagation();
            try {
                avalon.vmodels[modelID][key] = value;
            } catch (error) { console.log(error); }

        },

        /*
        * 信息收集
        * elements     category    {String}    事件发生在谁身上
        * elements     action      {String}    访客跟元素交互的行为动作
        * elements     label       {String}    用于详细的描述事件
        */
        sendCollect: function (category, action, label) {
            if (!window._czc) {
                setTimeout(function () { model.sendCollect(category, action, label); }, 1500);
                return;
            }
            setTimeout(function () {
                //声明 cnzz _czc 对象
                var _czc = window._czc || [];
                _czc.push(['_trackEvent', category, action, label || '']);   //发送统计
                console.log(category, action, label);
            }, 50);
        },

        openUrl: function (url) {
            WpsApi.openQingUrl(url);
        },

        loginOut: function () {
            if (model.isLogin) {
                WpsApi.logout();
            }
        },

        /**
         * 调起客户端支付窗
         */
        openPayment: function (str) {
            if (!model.isLogin) {
                model.login();
                return;
            } else {
                WpsApi.openPayment(str);
            }
        },

        /**
         * 更新用户信息
         */
        getUserInfo: function () {
            Login.updateUserInfo();
        },

        // 面板tab组件配置
        panelmenu: {
            //初始化获取面板tab组件VM
            onInit: function (vm) {
                model.panelmenuVM = vm;
            }
        },

        // 特权组件配置
        privilege: {
            //初始化获取特权组件VM
            onInit: function (vm) {
                model.privilegeVM = vm;
            }
        },

        // WPS会员统一支付
        buyMember: function (csource) {
            //未登录不弹框
            if (!model.isLogin) {
                WpsApi.login();
                return false;
            }
            csource = csource || 'vip';
            /**
             * 调用客户端统一支付弹窗
             */
            WpsApi.memberUniformPay(csource).done(function (resp) {
                if (resp.callstatus && resp.callstatus != 'ok') { }
            });
        },

        // 三种类型 home info security
        focusTab: 'home',
        choiceTab: function (name) {
            if (!model.isLogin) {
                WpsApi.login();
                return;
            }
            model.focusTab = name;
            location.href = '#!/' + name;
        },

        // 个人资料是否需要显示红点
        needRedPoint: false,
        // 红点右方提示文案
        remindText: '',
        // 是否需要认证
        need_verify: false,

        // 初始化面板
        initPanel: function () {
            // 获取认证信息
            DataServices.get('account').identity({data: {}}).done(function(resp) {
                resp = resp.data;
                if (resp.result == 'ok') {
                    model.need_verify = DATAMODEL.need_verify = resp.need_verify;
                    // 红点及其文案判断
                    model.redPointCheck();
                }
            });
        },

        // 红点及其文案判断
        redPointCheck: function () {
            // 第三方登录
            DATAMODEL.isThirdLoing = true,
                loginmode = DATAMODEL.userInfo.loginmode;
            // 非第三方登录
            if (loginmode.indexOf('phone') != -1 || loginmode.indexOf('email') != -1) {
                DATAMODEL.isThirdLoing = false;
            }
            // 已点击过头像或者第三方登录自动获取头像
            if (localStorage.getItem('hasClickEditPic-'+DATAMODEL.userInfo.userid) || DATAMODEL.isThirdLoing) {
                
                // 临时屏蔽认证部分逻辑
                model.needRedPoint = false;
                return;


                // 已经认证或者已经点过认证按钮
                if (!model.need_verify || localStorage.getItem('hasClickVerify-'+DATAMODEL.userInfo.userid)) {
                    model.needRedPoint = false;
                } else {
                    model.needRedPoint = true;
                    model.remindText = '仍未实名认证';
                }

            } else {
                model.needRedPoint = true;
                model.remindText = '仍未设置头像';
            }
        },
        
        winMaxFlag: false,
    });

    /* 
     * 事件订阅 - 用户信息更新
     */
    $.subscribe('updateUserInfo', function (a, resp) {
        $('html').css('overflow', 'hidden');
        var leftW = $('aside').width(),
            leftH = $('aside').height(),
            dragW = $(window).width() - leftW - 32 * 3;
        WpsApi.clearDragArea();
        WpsApi.addDragArea(0, 0, leftW, 14);
        WpsApi.addDragArea(37, 0, leftW - 37 * 2, 50);
        WpsApi.addDragArea(leftW, 0, dragW, 22);
        if (resp.result == 'ok') {
            model.info500 = false;
            model.isLogin = true;
            model.userInfo = window.DATAMODEL.userInfo;
            model.isCompany = window.DATAMODEL.isCompany;
            model.isSuper = window.DATAMODEL.isSuper;
            model.isDocer = window.DATAMODEL.isDocer;
            model.isWpsVip = window.DATAMODEL.isWpsVip;

            // 面板tab，初始化面板信息
            model.initPanel();

            // 特权，初始化
            if (model.privilegeVM) {
                model.privilegeVM._init();
            }
            HomeVM.init();
        } else {
            model.userInfo = '';
            model.isLogin = false;
            model.info500 = true;
            model.isCompany = model.isSuper = model.isDocer = model.isWpsVip = false;
        }
    });

    //示例 $.publish('buyMember',['vip']) vip是csource由产品决定
    $.subscribe('buyMember', function (a, t) {
        model.buyMember(t);
    });

    /**
     * 定义路由规则
     */
    avalon.router.get('/{path:.*}', function (path) {
        var params = path.split("/");
        var moduleId = params[0] || 'home',   // 一级路由
            urlParams = params[1] ? path.substring(path.indexOf('/') + 1) : ''; // 二级路由
        var query = this.query;

        if (moduleId === 'home') {
            model.content = 'home';
            model.sendCollect('首页-展示量');
            return;
        }

        require(['modules/' + moduleId + '/' + moduleId], function (module) {
            model.content = moduleId;
            if ($.isFunction(module.changeUrl)) {
                module.changeUrl(urlParams, query);
            }
        }, function (err) {
            console.error(err);
        });
    });

    /**
     * 开启监听路由
     */
    avalon.history.start({});

    /**
     * 开启页面扫描
     */
    avalon.scan();
    if (Utils.checkIsClient()) {
        window.onRestoreWindow = function (str) {
            var BASE64 = require('base64');
            var win_status = BASE64.decode(str);
            if (win_status === 'maximizewindow') {
                model.winMaxFlag = true;
            } else if (win_status === 'restorewindow') {
                model.winMaxFlag = false;
            }
        };
        WpsApi.addWindowStatusListener('onRestoreWindow');
    
        window.onresize = function () {
            var leftW = $('aside').width(),
                leftH = $('aside').height(),
                dragW = $(window).width() - leftW - 32 * 3;
            WpsApi.clearDragArea();
            WpsApi.addDragArea(0, 0, leftW, 14);
            WpsApi.addDragArea(37, 0, leftW - 37 * 2, 50);
            WpsApi.addDragArea(leftW, 0, dragW, 22);
        };
    }

    return model;
});