define(['dataServices'], function (DataServices) {

    avalon.component('ms:cloud', {
        // $replace: true,

        $dispose: function () {

        },

        $childReady: function () {

        },
        
        superHoverFlag: false,

        setSuperHoverValue: function (flag) {
            var model = avalon.vmodels[$(this).parents('[data-cloud-id]').attr('data-cloud-id')];
            model.superHoverFlag = flag;
            model.speed = 0;
            if (model.selfCloud === null) {
                return;
            } else if (model.selfCloud === '') {
                model.maxValue = 0;
            } else {
                var m2hadUseSpace = (window.parseInt(model.selfCloud.used / model.bytes * 1000) / 1000).toFixed(2);  // 使用了多少空间（M单位）
                m2hadUseSpace = Number(m2hadUseSpace);
                if (flag) { // 超级会员空间
                    model.superSpace = window.parseInt(avalon.vmodels.homeVM.cloud[40].user_space / model.bytes * 1000) / 1000;
                    model.maxValue = m2hadUseSpace / model.superSpace * 100;
                } else {
                    model.maxValue = m2hadUseSpace / model.selfSpace * 100;
                }
            }
            var cvas = $("#cloud_canvas")[0],
                canvas2D = cvas.getContext("2d");
            canvas2D.clearRect(0, 0, cvas.width, cvas.height);
            model.drawCircle();
            // console.log(model.selfSpace, model.superSpace, model.maxValue);
        },

        _timerid: '',
        maxValue: 0,
        speed: 0,
        /**
         * canvas动画
         */
        drawCircle: function () {
            var model = this;
            /* if (!avalon.vmodels.globleVM.isLogin) {
                // 防止canvas数据未及时返回
                setTimeout(function() {
                    model.drawCircle.apply(model);
                });
                return;
            } */
            var cvas = $("#cloud_canvas")[0],
                canvas2D = cvas.getContext("2d");
            if (model.speed > model.maxValue || model.speed >= 100) {
                window.cancelAnimationFrame(model._timerid);
                // canvas2D.closePath(); //路径结束
            } else {
                if (model.maxValue < 1) {
                    model.speed += 1;
                } else {
                    model.speed += 0.8;
                }
                canvas2D.clearRect(0, 0, cvas.width, cvas.height);
                /**
                 * 绘制加载的字体
                 */
                (function () {
                    canvas2D.save();
                    canvas2D.fillStyle = "#4a79fe";
                    canvas2D.textBaseline = 'middle';
                    canvas2D.textAlign = 'center';
                    canvas2D.font = "bold 36px 微软雅黑"; //设置字体大小和字体
                    var val = 0;
                    if (model.maxValue == 0) {
                        val = 0;
                    } else if (model.maxValue < 1) {
                        val = 1;
                    } else {
                        val = model.speed > 100 ? 100 : model.speed.toFixed(1);
                    }
                    //绘制字体，并且指定位置
                    canvas2D.fillText(val, cvas.width / 2, cvas.height / 2);
                    canvas2D.font = "bold 18px 微软雅黑";
                    var distance = 0;
                    if (val.toString().length === 2) {
                        distance = 30;
                    } else {
                        if (val.toString().length === 1) {
                            distance = 15;
                        } else {
                            if (val == 100) {
                                distance = 45;
                            } else {
                                distance = 50;
                            }
                        }
                    }
                    canvas2D.fillText("%", cvas.width / 2 + distance + 4, cvas.height / 2 - 6);
                    canvas2D.stroke(); //执行绘制
                    canvas2D.restore();
                })();

                /**
                 * 绘制 外圈加载条
                 */
                (function () {
                    canvas2D.save();//保存当前环境的状态(save和restore可以保证样式属性只运用于该段canvas元素)
                    canvas2D.lineWidth = 7; //设置线宽
                    canvas2D.lineCap = "round";

                    canvas2D.beginPath(); //灰底色路径开始
                    canvas2D.arc(cvas.width / 2, cvas.height / 2, 72, 0, 360 * Math.PI / 180, false);
                    canvas2D.strokeStyle = "#eaeaea";
                    canvas2D.stroke();

                    canvas2D.beginPath(); //路径开始
                    canvas2D.arc(cvas.width / 2, cvas.height / 2, 72, Math.PI * 0.5, Math.PI * 0.5 + model.speed * Math.PI * 2 / 100, false); //用于绘制圆弧canvas2D.arc(x坐标，y坐标，半径，起始角度，终止角度，顺时针/逆时针)
                    var grd = canvas2D.createLinearGradient(30,30,150,150);
                    //添加颜色断点
                    grd.addColorStop(0,"#52eff5");
                    grd.addColorStop(0.3,"#4a7dfe");
                    grd.addColorStop(0.7,"#4a7dfe");
                    grd.addColorStop(1,"#9b3aff");
                    //应用渐变
                    canvas2D.strokeStyle = grd;
                    canvas2D.stroke(); //绘制
                    canvas2D.restore();//返回之前保存过的路径状态和属性
                })();
                //requestAnimationFrame作用与setTimeInterval一样，不同的是它会根据浏览器的刷新频率自动调整动画的时间间隔。
                model._timerid = window.requestAnimationFrame(function() {
                    model.drawCircle.apply(model);
                }, cvas);
            }
        },
        
        /**
         * 自己空间信息
         */
        getSelfCloud: function () {
            var deff = $.Deferred();
            DataServices.get('home').getSelfCloud().done(function (resp) {
                deff.resolve(resp.data);
            }).fail(function () {
                deff.reject('networdk error');
            });
            return deff;
        },

        selfCloud: '',

        // 用户已经使用空间
        hadUseSpace: 0,

        bytes: 1048576 ,    // vm.bytes

        // 会员空间
        selfSpace: 0,
        // 超级会员空间
        superSpace: 0, 
        $ready: function (vm, el) {
            el.setAttribute('data-cloud-id', vm.$id);
        },

        renderData: function () {
            var vm = avalon.vmodels[$('[data-cloud-id]').attr('data-cloud-id')];
            var $cnv = $("#cloud_canvas")[0];
            if (!$cnv.getContext) {
                throw Error('你的浏览器不支持Canvas!');
            } else {
                canvas2D = $cnv.getContext("2d");
                canvas2D.clearRect(0, 0, $cnv.width, $cnv.height);
                vm.getSelfCloud().done(function (resp) {
                    console.log(`云文档Canvas数据：${JSON.stringify(resp)}`);
                    if (resp.id != '') {
                        vm.speed = 0;
                        vm.selfCloud = resp;
                        var m2hadUseSpace = (window.parseInt(vm.selfCloud.used / vm.bytes * 1000) / 1000).toFixed(2);  // 使用了多少空间（M单位）
                        m2hadUseSpace = Number(m2hadUseSpace);
                        if (m2hadUseSpace > 1024) {
                            vm.hadUseSpace = (m2hadUseSpace / 1024).toFixed(2) + 'G/'; // 单位为（G）
                        } else {
                            vm.hadUseSpace = m2hadUseSpace + 'M/';
                        }
                        if (avalon.vmodels.homeVM.cloud !='') {
                            vm.selfSpace = window.parseInt(avalon.vmodels.homeVM.cloud[avalon.vmodels.globleVM.userInfo.vip.memberid].user_space / vm.bytes * 1000) / 1000;
                            vm.superSpace = window.parseInt(avalon.vmodels.homeVM.cloud[40].user_space / vm.bytes * 1000) / 1000;
                        } else {
                            vm.selfSpace = 1024;
                        }
                        vm.maxValue = (m2hadUseSpace / vm.selfSpace * 100).toFixed(1);
                        vm.maxValue = Number(vm.maxValue);
                        console.log(vm.selfSpace, vm.superSpace, vm.maxValue);
                        vm.drawCircle();
                    } else {
                        throw Error('个人空间信息接口返回错误msg');
                    }
                }).fail(function(resp) {
                    vm.speed = 0;
                    vm.selfCloud = null;
                    vm.hadUseSpace = 0 + 'M/';
                    vm.selfSpace = 0;
                    vm.superSpace = 0;
                    vm.maxValue = 0.1;
                    vm.drawCircle();
                    console.log(resp);
                });
            }
        },

        $init: function () {
            // console.log('ms:cloud渲染调用');
        },

        $template: $('#cloud_template').html()
    });
});