define(['dataServices', 'utils', 'wpsApi', 'store', 'member', 'template', 'money', 'cloud'], function (DataServices, Utils, WpsApi, Store, MemberVM, TemplateVM, MoneyVM, CloudVM) {

    var model = avalon.define({

        $id: 'homeVM',

        $skipArray: [],

        /**
         * 调用globelVM的setValue方法
         */
        setValue: function (event, modelID, key, value) {
            avalon.vmodels.globleVM.setValue(event, modelID, key, value);
        },

        /**
         * 广告图片切换
         */
        selectAdIndex: 0,
        _timer: 0,
        selectAd: function (ind) {
            clearTimeout(model._timer);
            model.selectAdIndex = ind;
            model._timer = setTimeout(function () {
                model.autoScroll();
            }, 5000);
        },

        autoScroll: function () {
            if (model.bannerArr != '') {
                if ((model.selectAdIndex + 1) >= model.bannerArr.ad.length) {
                    model.selectAdIndex = 0;
                } else {
                    model.selectAdIndex++;
                }
                model._timer = setTimeout(function () {
                    model.autoScroll();
                }, 5000);
            }
        },

        /**
         * 数据聚合接口
         */
        getDashboard() {
            var deff = $.Deferred();
            DataServices.get('home').getDashboard().done(function (resp) {
                deff.resolve(resp.data);
            }).fail(function () {
                deff.reject('network error');
            });
            return deff.promise();
        },

        /**
         * 推荐模板数据
         */
        getRecommendMbs() {
            var deff = $.Deferred();
            DataServices.get('home').getRecommendMbs({
                data: {
                    mb_num: '10'
                }
            }).done(function (resp) {
                if (resp.data === {}) {
                    deff.resolve(resp.data);
                } else {
                    deff.resolve(resp.data);
                }
            }).fail(function () {
                deff.reject('networdk error');
            });
            return deff.promise();
        },

        /**
         * 自己空间信息
         */
        getSelfCloud() {
            var deff = $.Deferred();
            DataServices.get('home').getSelfCloud().done(function (resp) {
                deff.resolve(resp.data);
            }).fail(function () {
                deff.reject('networdk error');
            });
            return deff.promise();
        },

        money: '',
        template: '',
        templateRcArr: [],
        cloud: '',
        member: '',
        bannerArr: '',

        dataFormate: function (data) {
            model.money = {
                'myCoupon': data.usable_member_coupon_count,
                'giftCount': data.gift_count,
                'orderCount': data.exchange_count,
                'signCondition': data.sign_condition
            };
            model.template = {
                'hadBuy': data.muban_summary.buy,
                'hadCollect': data.muban_summary.colect,
                'lastUse': data.muban_summary.lateuse
            };
            model.cloud = data.doc_member_privilege_conf;
            var wpsdata = null,
                docerdata = null,
                superdata = null;
            avalon.each(data.member_dashboard, function (key, el) {
                if (el.title === 'wps会员') {
                    wpsdata = el;
                } else if (el.title === '稻壳会员') {
                    docerdata = el;
                } else if (el.title === '超级会员') {
                    superdata = el;
                } else if (el.title === '广告_banner') {
                    model.bannerArr = el;
                }
            });
            model.member = {
                docerType: docerdata,
                wpsType: wpsdata,
                superType: superdata
            };
                MemberVM.init(model.member.$model);
                TemplateVM.init(model.template.$model, model.templateRcArr.$model);
                MoneyVM.init(model.money.$model);
            // console.log(model.bannerArr.$model);
        },

        /**
         * 路由去安全中心并且选中
         */
        gotoSecurity: function () {
            $('.leftnav li').eq(2).click();
            location.href = '#!/security';
        },

        /**
         * 路由入口函数
         * @param {Array} urlParams 
         * @param {Object} query
         * http://panel.wps.cn/#!/?sign=0
         */
        changeUrl: function (urlParams, query) {

        },

        homeVMStatus: 'init', // homevm状态 init - loadingdata - datafinish
        /**
         * 入口
         */
        init: () => {
            let deff = $.Deferred();
            $.when(model.getRecommendMbs(), model.getDashboard(), model.getSelfCloud()).done((rcResult, dashboradResult, cloudResult) => {
                model.homeVMStatus = 'datafinish';
                console.log(`推荐模板：${rcResult}`);
                if (rcResult.result === 'ok') {
                    model.templateRcArr = rcResult.data.rec_mbs;
                    Store('templateRcArr', rcResult.data.rec_mbs);
                } else {
                    throw Error('推荐模板接口返回错误msg');
                }
                if (dashboradResult.result === 'ok') {
                    console.log(`用户聚合数据： ${dashboradResult}`);
                    model.dataFormate(dashboradResult.data);
                    setTimeout(function () {
                        model.autoScroll();
                    }, 5000);
                } else {
                    throw Error('聚合信息接口返回错误msg');
                }
                if (cloudResult.id !== '') {
                    console.log(`Canvas- 云文档自己空间 -数据：${JSON.stringify(cloudResult)}`);
                    CloudVM.init(model.cloud.$model, cloudResult);
                } else {
                    throw Error('个人空间信息接口返回错误msg');
                }
            })
            return deff;
        },
    });

    //     /* model.money = Store('money');
    //     model.template = Store('template');
    //     model.cloud = Store('cloud');
    //     model.member = Store('member'); */
    //     model.templateRcArr = Store('templateRcArr') || [];

    avalon.scan();
    return model;
});