/*
 * File: member.js
 * Project: home
 * File Created: Wednesday, 14th March 2018 11:35:30 am
 * Author: cipo wu (236307533@qq.com)
 * -----
 * Last Modified: Wed Mar 14 2018
 * Modified By: cipo wu
 * -----
 * Copyright WPS
 */
define(['dataServices'], (DataServices) => {
    'use strict';
    let model = avalon.define({
        $id: 'memberVM',

        htmlStr: $('#member_template').html(),

        data: '',

        /**
         * 打开特权列表窗口
         */
        privBoxFlag: false,
        privhtml: '',
        openPrivBox: function () {
            if (model.privhtml === '') {
                DataServices.get('user').getMsgPriviliage({
                    data: {
                        csource: 'pc_center',
                        pay_config: 'personalcenter_vip',
                        position: 'info_apply'
                    }
                }).done(function (resp) {
                    console.log(resp);
                    if (resp.callstatus === 'ok' && resp.data && resp.data.result === 'ok' && resp.data.data.labels.wpsPrivilegeHtml) {
                        // 插入HTML信息
                        model.privhtml = resp.data.data.labels.wpsPrivilegeHtml;
                        model.privBoxFlag = true;
                    } else {
                        model.privBoxFlag = false;
                    }
                });
            } else {
                model.privBoxFlag = true;
            }
        },
        
        init: (val) => {
            model.data = val;
            console.info('个人主页-会员展示区域-正常');
        }
    });

    return model;
});