/*
 * File: template.js
 * Project: home
 * File Created: Wednesday, 14th March 2018 11:51:37 am
 * Author: cipo wu (236307533@qq.com)
 * -----
 * Last Modified: Thu Mar 15 2018
 * Modified By: cipo wu
 * -----
 * Copyright WPS
 */
define(['wpsApi'], (WpsApi) => {
    'use strict';
    let model = avalon.define({
        $id: 'templateVM',

        htmlStr: $('#temp_template').html(),
        
        data: '',
        rcdata: [], // 推荐模板

        /**
         * 模板-最近使用
         */
        gotoHistory: () => {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            WpsApi.gotoHistory();
        },

        /**
         * 模板-已购买
         */
        gotoPurchases: () => {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            WpsApi.gotoPurchases();
        },

        /**
         * 模板-已收藏
         */
        gotoFav: () => {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            WpsApi.gotoFav();
        },

        /**
         * 模板-我的模板
         */
        gotoMyTemplate: () => {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            WpsApi.gotoMyTemplate();
        },
        
        cssLeftValue: 0,    // 滚动点击

        goRorL: (arrow) => {
            if (arrow === '-') {
                if (model.cssLeftValue === 0) {
                    return false;
                }
                model.cssLeftValue+= 220;
            } else {
                if (model.cssLeftValue === (0 - avalon.vmodels.homeVM.templateRcArr.length * 220 + 220)) {
                    return false;
                }
                model.cssLeftValue-= 220;
            }
            return true;
        },
        
        init: (val, rcVal) => {
            model.data = val;
            model.rcdata = rcVal;
            console.info('个人主页-模板展示区域-正常');
        }
    });

    return model;
});