define(['wpsApi'], function(WpsApi) {

    var modulePath = 'security';
    avalon.templateCache[modulePath] = $('#security_template').html();
    avalon.vmodels.globleVM.content = modulePath;

    var model = avalon.define({

        $id: 'securityVM',

        $skipArray: [],

        // 当窗口小于680时，则为true，添加对应样式
        smallWin: false,

        /**
         * 入口
         */
        init: function() {
            avalon.vmodels.globleVM.sendCollect('首页-展示量');

            // 只监听有效的方法
            var validMethod = [
                    'getAutoRoamingMode',
                    'changeRoamingMode',
                    'openWebAuthDialog',
                    'setWebAuthResult',
                    'getUserInfo'
                ],
                data, method, postData;

            window.addEventListener('message', function(e) {
                data = JSON.parse(e.data);
                method = data.method;
                // 过滤
                if ($.inArray(method, validMethod) == -1) { return; }

                WpsApi[method](data.params).done(function(resp) {
                    // 同步方法
                    if (data.method == 'getUserInfo') {
                        postData = {
                            id: data.id,
                            status: 'success',
                            result: resp
                        }
                    } else {
                        postData = {
                            type: 'callback',
                            name: data.id,
                            result: resp
                        };
                    }
                    window.frames['security'].postMessage(JSON.stringify(postData), '*');

                });
            }, false);

            window.onresize = function(){
                if (document.documentElement.clientHeight < 680) {
                    model.smallWin = true;
                } else {
                    model.smallWin = false;
                }
            }

        }
    });

    model.init();
    return model;
});